#include <SPI.h>
#include <RF24.h>

// Pin definitions for the nRF24L01+ module
#define CE_PIN   7
#define CSN_PIN  8

// Set up RF24 radio
RF24 radio(CE_PIN, CSN_PIN);

// Address of the receiver
const byte address[6] = "00001";

void setup() {
  // Initialize serial communication
  Serial.begin(57600);

  // Start the radio
  radio.begin();

  // Set the  to 250 kbps
  radio.setDataRate(RF24_250KBPS);

  // Set the channel to 0
  radio.setChannel(100);

  // Set the power level to minimum
  radio.setPALevel(RF24_PA_MIN);

  // Set the address of the receiver
  radio.openReadingPipe(0, address);

  // Start listening for data
  radio.startListening();
}

void loop() {
  // Check if data is available
  if (radio.available()) {
    // Read the data into a character array
    char charArray[80];
    radio.read(&charArray, sizeof(charArray));

    // Convert the character array to a string
    String dateTimeString = String(charArray);

    // Print the date and time string
    Serial.println(dateTimeString);
  }
}
